class Vampire extends Mutator config(UTmod_v3);

var config int MaxHealth, SpawnPenalty;
var config bool bDrainHealth;
var config String DeathMessage, ShootWhileSpawnSound;
var config bool bVampireMode;

var sound SpawnSnd;

var bool Init;

function PostBeginPlay()
{
	if (Init)
		return;
	Init = True;

	Level.Game.RegisterDamageMutator(Self);

	log("Mutator_DamageToScore Initialized");

	if ( bDrainHealth && bVampireMode )
		{
		settimer(1.0, true);
		}

	SpawnSnd = Sound(DynamicLoadObject(ShootWhileSpawnSound, class'Sound'));

}

function Timer()
{
local Pawn P;
local Inventory inv;
local bool bSpawning;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		bSpawning = False;
		for (inv=P.Inventory; inv!=None; inv=inv.Inventory)
			{
			if ( inv.IsA('Spawnprotector') )
				{
				bSpawning = True;
				}
			}
		if ( P.Health == 1 && !P.PlayerReplicationInfo.bIsSpectator && !bSpawning)
			{
			P.TakeDamage(1, None, P.Location, vect(0,0,0), 'Fell');
			P.ClientMessage(DeathMessage, 'Pickup');
			P.PlaySound(Sound'UnrealShare.Gibs.Gib1',,2.0);
			}
		else if ( !P.PlayerReplicationInfo.bIsSpectator && !bSpawning )
			P.Health--;
		if ( P.Health < 0 )
			P.Health = 0;
		}
	
}

function MutatorTakeDamage( out int ActualDamage, Pawn Victim, Pawn InstigatedBy, out Vector HitLocation, out Vector Momentum, name DamageType)
{
local int CurrentHealth, OldHealth;
local Inventory inv;
local bool bSpawning;

	if ( Victim == InstigatedBy || Victim == None || InstigatedBy == None)
		Return;

	for (inv=Victim.Inventory; inv!=None; inv=inv.Inventory)
			{
			if ( inv.IsA('Spawnprotector') )
				{
				bSpawning = True;
				Momentum = Vect(0,0,0);
				ActualDamage = 0;
				InstigatedBy.ClientMessage("Don't shoot at spawners!!", 'Pickup');
				InstigatedBy.PlaySound(SpawnSnd,,2.0);
				if ( Level.Game.bTeamGame && SpawnPenalty > 0 )
					{
					if ( InstigatedBy.PlayerReplicationInfo.Team != Victim.PlayerReplicationInfo.Team )
						{
						InstigatedBy.TakeDamage(SpawnPenalty, None, InstigatedBy.Location, vect(0,0,0), 'Suicided');
						}
					}
				else if ( SpawnPenalty > 0 )
					{
					InstigatedBy.TakeDamage(SpawnPenalty, None, InstigatedBy.Location, vect(0,0,0), 'Suicided');
					}
				}
			}
	for (inv=InstigatedBy.Inventory; inv!=None; inv=inv.Inventory)
			{
			if ( inv.IsA('Spawnprotector') )
				{
				bSpawning = True;
				Momentum = Vect(0,0,0);
				ActualDamage = 0;
				InstigatedBy.ClientMessage("Don't shoot while spawning!!", 'Pickup');
				InstigatedBy.PlaySound(SpawnSnd,,2.0);
				OldHealth = InstigatedBy.Health;
				if ( Level.Game.bTeamGame && SpawnPenalty > 0 )
					{
					if ( InstigatedBy.PlayerReplicationInfo.Team != Victim.PlayerReplicationInfo.Team )
						{
						InstigatedBy.TakeDamage(SpawnPenalty, None, InstigatedBy.Location, vect(0,0,0), 'Suicided');
						InstigatedBy.Health = OldHealth - SpawnPenalty;
						}
					}
				else if ( SpawnPenalty > 0 )
					{
					InstigatedBy.TakeDamage(SpawnPenalty, None, InstigatedBy.Location, vect(0,0,0), 'Suicided');
					InstigatedBy.Health = OldHealth - SpawnPenalty;
					}
				}
			}

	if ( !bSpawning && InstigatedBy != None && Victim != None && bVampireMode )
     		{
		CurrentHealth = Victim.Health;
		if ( ActualDamage > CurrentHealth )
			{
			InstigatedBy.Health += CurrentHealth;
			}
		else
			{
			InstigatedBy.Health += ActualDamage;
			}
		if ( InstigatedBy.Health > MaxHealth )
			{
			InstigatedBy.Health = MaxHealth;
			}
     		}

	if ( !bSpawning )
		{
		Super.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
		if ( NextDamageMutator != None )
			{
     			NextDamageMutator.MutatorTakeDamage( ActualDamage, Victim, InstigatedBy, HitLocation, Momentum, DamageType);
			}
		}

	
}

defaultproperties
{
}
